Ext.data.JsonP.sol_common_ix_functions_RemoveAcl({"tagname":"class","name":"sol.common.ix.functions.RemoveAcl","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.RemoveAcl.js","href":"sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloix":true,"requires":["sol.common.AclUtils","sol.common.JsonUtils","sol.common.RepoUtils","sol.common.WfUtils","sol.common.ix.FunctionBase","sol.common.ix.RfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":[],"uses":[],"members":[{"name":"asAdmin","tagname":"cfg","owner":"sol.common.ix.functions.RemoveAcl","id":"cfg-asAdmin","meta":{}},{"name":"mapKey","tagname":"cfg","owner":"sol.common.ix.functions.RemoveAcl","id":"cfg-mapKey","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.functions.RemoveAcl","id":"cfg-objId","meta":{"required":true}},{"name":"recursive","tagname":"cfg","owner":"sol.common.ix.functions.RemoveAcl","id":"cfg-recursive","meta":{}},{"name":"removeDelete","tagname":"cfg","owner":"sol.common.ix.functions.RemoveAcl","id":"cfg-removeDelete","meta":{}},{"name":"removeEdit","tagname":"cfg","owner":"sol.common.ix.functions.RemoveAcl","id":"cfg-removeEdit","meta":{}},{"name":"removeList","tagname":"cfg","owner":"sol.common.ix.functions.RemoveAcl","id":"cfg-removeList","meta":{}},{"name":"removePermission","tagname":"cfg","owner":"sol.common.ix.functions.RemoveAcl","id":"cfg-removePermission","meta":{}},{"name":"removeRead","tagname":"cfg","owner":"sol.common.ix.functions.RemoveAcl","id":"cfg-removeRead","meta":{}},{"name":"removeWrite","tagname":"cfg","owner":"sol.common.ix.functions.RemoveAcl","id":"cfg-removeWrite","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"users","tagname":"cfg","owner":"sol.common.ix.functions.RemoveAcl","id":"cfg-users","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"rights","tagname":"property","owner":"sol.common.ix.functions.RemoveAcl","id":"property-rights","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"initRights","tagname":"method","owner":"sol.common.ix.functions.RemoveAcl","id":"method-initRights","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.functions.RemoveAcl","id":"method-initialize","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.RemoveAcl","id":"method-process","meta":{}},{"name":"RF_sol_function_RemoveAcl","tagname":"method","owner":"sol.common.ix.functions.RemoveAcl","id":"static-method-RF_sol_function_RemoveAcl","meta":{"static":true}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.functions.RemoveAcl","id":"static-method-onEnterNode","meta":{"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.functions.RemoveAcl","id":"static-method-onExitNode","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.RemoveAcl","short_doc":"Removes ACL from a folder. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.RemoveAcl</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.AclUtils' rel='sol.common.AclUtils' class='docClass'>sol.common.AclUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl' target='_blank'>sol.common.ix.functions.RemoveAcl.js</a></div></pre><div class='doc-contents'><p>Removes ACL from a folder.</p>\n\n<p>The function can be configured which access rights of which users should be removed.\nThe default would be, that all access rights (except read) will be removed for all existing ACL entries.</p>\n\n<p>In addition the original ACL entries can be stored (backed up) to a map field.</p>\n\n<h1>As workflow node</h1>\n\n<p>ObjId is set based on the element that the workflow is attached to.\nFollowing configuration would remove all access right (except read) for all existing ACL entries on the element and all sub elements.\nThe previous ACL entries will be saved to a map field (on each processed object).</p>\n\n<pre><code>{\n  \"mapKey\": \"ACL_BACKUP\",\n  \"recursive\": true\n}\n</code></pre>\n\n<h1>As IX function call</h1>\n\n<p>The following call would remove all access rights for the two users Paul and George (including the 'changePermissions' right since ELO12) just for the object itself. The previous ACL entries will be saved to a map field.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_sol_function_RemoveAcl', {\n  objId: \"4711\",\n  mapKey: 'PREVIOUS_ACL',     //optional\n  users: [\"paul\", \"george\"],  //optional\n  recursive: false,           //optional\n  removeRead: true,           //optional\n  removeWrite: true,          //optional\n  removeDelete: true,         //optional\n  removeEdit: true,           //optional\n  removeList: true,           //optional\n  removePermission: true,     //optional\n  asAdmin: true               //optional\n});\n</code></pre>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-objId' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>ObjectId of folder structure</p>\n</div><div class='long'><p>ObjectId of folder structure</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-cfg-objId\" rel=\"sol.common.ix.FunctionBase-cfg-objId\" class=\"docClass\">sol.common.ix.FunctionBase.objId</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-asAdmin' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-cfg-asAdmin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-cfg-asAdmin' class='name expandable'>asAdmin</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-mapKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-cfg-mapKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-cfg-mapKey' class='name expandable'>mapKey</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nName of Mapfield to store removed ACL when set</p>\n</div><div class='long'><p>(optional)\nName of Mapfield to store removed ACL when set</p>\n</div></div></div><div id='cfg-recursive' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-cfg-recursive' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-cfg-recursive' class='name expandable'>recursive</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-removeDelete' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-cfg-removeDelete' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-cfg-removeDelete' class='name expandable'>removeDelete</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-removeEdit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-cfg-removeEdit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-cfg-removeEdit' class='name expandable'>removeEdit</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-removeList' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-cfg-removeList' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-cfg-removeList' class='name expandable'>removeList</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-removePermission' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-cfg-removePermission' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-cfg-removePermission' class='name expandable'>removePermission</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-removeRead' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-cfg-removeRead' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-cfg-removeRead' class='name expandable'>removeRead</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-removeWrite' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-cfg-removeWrite' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-cfg-removeWrite' class='name expandable'>removeWrite</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-users' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-cfg-users' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-cfg-users' class='name expandable'>users</a> : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nGroup and/or user names of which the ACL should be removed. ...</div><div class='long'><p>(optional)\nGroup and/or user names of which the ACL should be removed. If empty, all existing ACL items will be processed.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div><div id='property-rights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-property-rights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-property-rights' class='name expandable'>rights</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-initRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-method-initRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-method-initRights' class='name expandable'>initRights</a>( <span class='pre'>config</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>rights</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Removes ACL from whole folder structure. ...</div><div class='long'><p>Removes ACL from whole folder structure.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_function_RemoveAcl' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-static-method-RF_sol_function_RemoveAcl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-static-method-RF_sol_function_RemoveAcl' class='name expandable'>RF_sol_function_RemoveAcl</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div><div id='static-method-onEnterNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.RemoveAcl'>sol.common.ix.functions.RemoveAcl</span><br/><a href='source/sol.common.ix.functions.RemoveAcl.html#sol-common-ix-functions-RemoveAcl-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.RemoveAcl-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});